/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.command;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.response.NameAndId;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_12099;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2861;
import net.minecraft.class_2960;
import net.minecraft.class_3193;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3908;
import net.minecraft.class_52;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9240;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.command.ILootrCommandExtension;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.block.LootrBarrelBlock;
import noobanidus.mods.lootr.common.block.LootrChestBlock;
import noobanidus.mods.lootr.common.block.LootrShulkerBlock;
import noobanidus.mods.lootr.common.block.entity.BlockEntityTicker;
import noobanidus.mods.lootr.common.block.entity.LootrInventoryBlockEntity;
import noobanidus.mods.lootr.common.command.CustomConvertJob;
import noobanidus.mods.lootr.common.data.DataStorage;
import noobanidus.mods.lootr.common.data.LootrInventory;
import noobanidus.mods.lootr.common.data.LootrSavedData;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.common.impl.IChunkMapGetChunks;
import noobanidus.mods.lootr.common.impl.LootrServiceRegistry;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinBaseContainerBlockEntity;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinMinecraftServer;
import org.jetbrains.annotations.Nullable;

public class CommandLootr {
    private static List<class_5321<class_52>> tables = null;
    private static List<String> tableNames = null;
    private static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private static final FilenameFilter MCA_FILTER = (file, fileName) -> fileName.endsWith(".mca");

    private static List<class_5321<class_52>> getTables(MinecraftServer server) {
        if (tables == null) {
            tables = server.method_58576().method_58294().method_46759(class_7924.field_50079).map(class_7225::method_46754).orElse(Stream.of(new class_5321[0])).toList();
            tableNames = tables.stream().map(o -> o.method_29177().toString()).toList();
        }
        return tables;
    }

    private static List<String> getTableNames(MinecraftServer server) {
        CommandLootr.getTables(server);
        return tableNames;
    }

    public static void createBlock(class_2168 c, @Nullable class_2248 block, @Nullable class_5321<class_52> incomingTable) {
        class_3218 world = c.method_9225();
        class_243 incomingPos = c.method_9222();
        class_2338 pos = new class_2338((int)incomingPos.field_1352, (int)incomingPos.field_1351, (int)incomingPos.field_1350);
        class_5321<class_52> table = incomingTable == null ? CommandLootr.getTables(c.method_9211()).get(world.method_8409().method_43048(CommandLootr.getTables(c.method_9211()).size())) : incomingTable;
        if (block == null) {
            LootrChestMinecartEntity cart = new LootrChestMinecartEntity((class_1937)world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            class_1297 e = c.method_9228();
            if (e != null) {
                cart.method_36456(e.method_36454());
            }
            cart.method_7562(table, world.method_8409().method_43055());
            world.method_8649((class_1297)cart);
            c.method_9226(() -> class_2561.method_43469((String)"lootr.commands.summon", (Object[])new Object[]{class_2564.method_10885((class_2561)class_2561.method_43469((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1060)).method_10982(Boolean.valueOf(true)))), table.toString()}), false);
        } else {
            class_2680 placementState = block.method_9564();
            class_1297 e = c.method_9228();
            if (e != null) {
                class_2754 prop = null;
                class_2350 dir = class_2350.method_10159((class_1297)e)[0].method_10153();
                if (placementState.method_28498((class_2769)LootrBarrelBlock.field_16320)) {
                    prop = LootrBarrelBlock.field_16320;
                } else if (placementState.method_28498((class_2769)LootrChestBlock.field_10768)) {
                    prop = LootrChestBlock.field_10768;
                    dir = e.method_5735().method_10153();
                } else if (placementState.method_28498((class_2769)LootrShulkerBlock.field_11496)) {
                    prop = LootrShulkerBlock.field_11496;
                }
                if (prop != null) {
                    placementState = (class_2680)placementState.method_11657((class_2769)prop, (Comparable)dir);
                }
            }
            world.method_8652(pos, placementState, 2);
            ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(world.method_8321(pos));
            if (iLootrBlockEntity instanceof ILootrBlockEntity) {
                ILootrBlockEntity randomizableBe = iLootrBlockEntity;
                randomizableBe.setLootTableInternal(table, world.method_8409().method_43055());
            }
            c.method_9226(() -> class_2561.method_43469((String)"lootr.commands.create", (Object[])new Object[]{class_2561.method_43471((String)block.method_63499()), class_2564.method_10885((class_2561)class_2561.method_43469((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1060)).method_10982(Boolean.valueOf(true)))), table.toString()}), false);
        }
    }

    static class_2371<class_1799> copyItemList(class_2371<class_1799> reference) {
        class_2371 contents = class_2371.method_10213((int)reference.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((class_1799)reference.get(i)).method_7972());
        }
        return contents;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(CommandLootr.builder((LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)class_2170.method_9247((String)"lootr").requires(p -> p.method_75037().hasPermission(class_12099.field_63210)))));
    }

    private static RequiredArgumentBuilder<class_2168, class_2960> suggestTables() {
        return class_2170.method_9244((String)"table", (ArgumentType)class_2232.method_9441()).suggests((c, build) -> class_2172.method_9265(CommandLootr.getTableNames(((class_2168)c.getSource()).method_9211()), (SuggestionsBuilder)build));
    }

    public static LiteralArgumentBuilder<class_2168> builder(LiteralArgumentBuilder<class_2168> builder) {
        builder.executes(c -> {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43469((String)"lootr.commands.usage", (Object[])new Object[]{class_2561.method_43470((String)LootrServiceRegistry.getCommandExtensionsString())}), false);
            return 1;
        });
        for (ILootrCommandExtension extension : LootrServiceRegistry.getCommandExtensions()) {
            builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)extension.getId()).executes(c -> {
                CommandLootr.createBlock((class_2168)c.getSource(), extension.getBlock(), null);
                return 1;
            })).then(CommandLootr.suggestTables().executes(c -> {
                CommandLootr.createBlock((class_2168)c.getSource(), extension.getBlock(), (class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2232.method_9443((CommandContext)c, (String)"table")));
                return 1;
            })));
        }
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").executes(c -> {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Must provide player name."), true);
            return 1;
        })).then(class_2170.method_9244((String)"profile", (ArgumentType)StringArgumentType.string()).executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            Optional opt_profile = ((class_2168)c.getSource()).method_9211().method_73550().comp_839().findProfileByName(playerName);
            if (!opt_profile.isPresent()) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid player name: " + playerName + ", profile not found in the cache.")));
                return 0;
            }
            NameAndId profile = (NameAndId)opt_profile.get();
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)(LootrAPI.clearPlayerLoot(profile.id()) ? "Cleared stored inventories for " + playerName : "No stored inventories for " + playerName + " to clear")), true);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cart").executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), null, null);
            return 1;
        })).then(CommandLootr.suggestTables().executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), null, (class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2232.method_9443((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"custom-chest").executes(c -> {
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2680 state = level.method_8320(pos);
            if (!state.method_26164(LootrTags.Blocks.CUSTOM_ELIGIBLE)) {
                pos = pos.method_10074();
                state = level.method_8320(pos);
            }
            if (!state.method_26164(LootrTags.Blocks.CUSTOM_ELIGIBLE)) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on the container you wish to convert."), false);
            } else {
                class_2586 blockEntity = level.method_8321(pos);
                if (!(blockEntity instanceof class_2624)) {
                    ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on the container you wish to convert."), false);
                    return 0;
                }
                class_2624 container = (class_2624)blockEntity;
                class_2371<class_1799> reference = ((AccessorMixinBaseContainerBlockEntity)blockEntity).invokeGetItems();
                class_2680 newState = CommandLootr.updateBlockState(state, LootrRegistry.getInventoryBlock().method_9564());
                class_2371<class_1799> custom = CommandLootr.copyItemList(reference);
                level.method_8544(pos);
                level.method_8501(pos, newState);
                class_2586 te = level.method_8321(pos);
                if (!(te instanceof LootrInventoryBlockEntity)) {
                    ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Unable to convert chest, BlockState is not a Lootr Inventory block."), false);
                } else {
                    LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.method_5431();
                }
            }
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"open_as").executes(c -> {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Must provide player name."), true);
            return 1;
        })).executes(c -> {
            ILootrBlockEntity ibe;
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            Optional opt_profile = ((class_2168)c.getSource()).method_9211().method_73550().comp_839().findProfileByName(playerName);
            if (!opt_profile.isPresent()) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid player name: " + playerName + ", profile not found in the cache.")));
                return 0;
            }
            NameAndId profile = (NameAndId)opt_profile.get();
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2586 te = level.method_8321(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.method_10074();
                te = level.method_8321(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
                return 0;
            }
            LootrSavedData data = DataStorage.getData(ibe);
            if (data == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"No Lootr data found for this container."), false);
                return 0;
            }
            LootrInventory inventory = data.getInventory(profile.id());
            if (inventory == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("No stored inventory for " + playerName + " found.")), true);
                return 0;
            }
            class_3222 player = ((class_2168)c.getSource()).method_44023();
            if (player == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Command can only be executed by a player"), false);
                return 0;
            }
            player.method_17355((class_3908)inventory);
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"open_as_uuid").executes(c -> {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Must provide player UUID."), true);
            return 1;
        })).then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(c -> {
            ILootrBlockEntity ibe;
            UUID id;
            String uuid = StringArgumentType.getString((CommandContext)c, (String)"uuid");
            try {
                id = UUID.fromString(uuid);
            }
            catch (IllegalArgumentException exception) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid UUID: " + uuid)));
                return 0;
            }
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2586 te = level.method_8321(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.method_10074();
                te = level.method_8321(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
                return 0;
            }
            LootrSavedData data = DataStorage.getData(ibe);
            if (data == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"No Lootr data found for this container."), true);
                return 0;
            }
            LootrInventory inventory = data.getInventory(id);
            if (inventory == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("No stored inventory for " + String.valueOf(id) + " found.")), true);
                return 0;
            }
            class_3222 player = ((class_2168)c.getSource()).method_44023();
            if (player == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Command can only be executed by a player"), false);
                return 0;
            }
            player.method_17355((class_3908)inventory);
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"id").executes(c -> {
            ILootrBlockEntity ibe;
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 world = ((class_2168)c.getSource()).method_9225();
            class_2586 te = world.method_8321(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.method_10074();
                te = world.method_8321(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
            } else {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"The ID of this inventory is: ").method_10852((class_2561)class_2564.method_47523((String)ibe.getInfoUUID().toString())), false);
            }
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"refresh").executes(c -> {
            ILootrBlockEntity ibe;
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2586 be = level.method_8321(pos);
            if (!(LootrAPI.resolveBlockEntity(be) instanceof ILootrBlockEntity)) {
                pos = pos.method_10074();
                be = level.method_8321(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(be)) != null) {
                LootrAPI.setRefreshing(ibe);
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Container with ID " + String.valueOf(ibe.getInfoUUID()) + " has been set to refresh with a delay of " + LootrAPI.getRefreshValue())), false);
            } else {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"decay").executes(c -> {
            ILootrBlockEntity ibe;
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2586 be = level.method_8321(pos);
            if (!(LootrAPI.resolveBlockEntity(be) instanceof ILootrBlockEntity)) {
                pos = pos.method_10074();
                be = level.method_8321(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(be)) != null) {
                LootrAPI.setDecaying(ibe);
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Container with ID " + String.valueOf(ibe.getInfoUUID()) + " has been set to decay with a delay of " + LootrAPI.getDecayValue())), false);
            } else {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"openers").then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).executes(c -> {
            class_2338 position = class_2277.method_9734((CommandContext)c, (String)"location").method_9704((class_2168)c.getSource());
            class_3218 world = ((class_2168)c.getSource()).method_9225();
            class_2586 blockEntity = world.method_8321(position);
            ILootrBlockEntity ibe = LootrAPI.resolveBlockEntity(blockEntity);
            if (ibe != null) {
                Set<UUID> openers = ibe.getActualOpeners();
                if (openers != null) {
                    ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("BlockEntity at location " + String.valueOf(position) + " has " + openers.size() + " openers. UUIDs as follows:")), true);
                    for (UUID uuid : openers) {
                        Optional prof = ((class_2168)c.getSource()).method_9211().method_73550().comp_4624().method_73290(uuid);
                        ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("UUID: " + String.valueOf(uuid) + ", user profile: " + (prof.isPresent() ? ((GameProfile)prof.get()).name() : "null"))), true);
                    }
                }
            } else {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("No Lootr block entity exists at location: " + String.valueOf(position))), false);
            }
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"custom-map").then(class_2170.method_9244((String)"level", (ArgumentType)class_2181.method_9288()).executes(c -> {
            class_3218 levelKey = class_2181.method_9289((CommandContext)c, (String)"level");
            CustomConvertJob.start(((class_2168)c.getSource()).method_9211(), levelKey, CommandLootr.getAllChunkPositions(levelKey), (class_2168)c.getSource());
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"custom-area").then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_3341 bounds = class_3341.method_34390((class_2382)class_2262.method_9696((CommandContext)context, (String)"from"), (class_2382)class_2262.method_9696((CommandContext)context, (String)"to"));
            class_1923 start = new class_1923(new class_2338(bounds.method_35415(), bounds.method_35416(), bounds.method_35417()));
            class_1923 stop = new class_1923(new class_2338(bounds.method_35418(), bounds.method_35419(), bounds.method_35420()));
            ArrayList<class_1923> positions = new ArrayList<class_1923>();
            for (int x = start.field_9181; x <= stop.field_9181; ++x) {
                for (int z = start.field_9180; z <= stop.field_9180; ++z) {
                    positions.add(new class_1923(x, z));
                }
            }
            class_3218 level = ((class_2168)context.getSource()).method_9225();
            for (class_1923 chunkPos : positions) {
                class_2818 chunk = level.method_8497(chunkPos.field_9181, chunkPos.field_9180);
                ArrayList<class_2338> convertableBlocks = new ArrayList<class_2338>();
                for (class_2338 pos : chunk.method_12021()) {
                    if (!bounds.method_14662((class_2382)pos)) continue;
                    convertableBlocks.add(pos);
                }
                if (convertableBlocks.isEmpty()) continue;
                for (class_2338 pos : convertableBlocks) {
                    class_2680 state;
                    class_2621 lootContainer;
                    class_2586 blockEntity = chunk.method_12201(pos, class_2818.class_2819.field_12860);
                    if (!(blockEntity instanceof class_2624) || blockEntity instanceof class_2621 && (lootContainer = (class_2621)blockEntity).method_54869() != null || (state = blockEntity.method_11010()).method_26164(LootrTags.Blocks.CUSTOM_ELIGIBLE) || blockEntity.method_11017().method_53254().method_40220(LootrTags.BlockEntity.CUSTOM_INELIGIBLE)) continue;
                    class_2371<class_1799> reference = ((AccessorMixinBaseContainerBlockEntity)blockEntity).invokeGetItems();
                    class_2680 newState = CommandLootr.updateBlockState(state, LootrRegistry.getInventoryBlock().method_9564());
                    class_2371<class_1799> custom = CommandLootr.copyItemList(reference);
                    level.method_8544(pos);
                    level.method_8501(pos, newState);
                    class_2586 te = level.method_8321(pos);
                    if (!(te instanceof LootrInventoryBlockEntity)) {
                        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Unable to convert chest at '" + String.valueOf(pos) + "', BlockState is not a Lootr Inventory block.")));
                        continue;
                    }
                    LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.method_5431();
                }
            }
            return 1;
        }))));
        builder.then(class_2170.method_9247((String)"cclear").then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(c -> {
            Collection entities = class_2186.method_9317((CommandContext)c, (String)"entities");
            for (class_1297 e : entities) {
                if (!(e instanceof class_1657)) continue;
                class_1657 player = (class_1657)e;
                String name = player.method_5820();
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)(DataStorage.clearInventories(player.method_5667()) ? "Cleared stored inventories for " + name : "No stored inventories for " + name + " to clear")), true);
            }
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"cull").executes(c -> {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Going to asynchronously cull " + DataStorage.cullInventories() + " inventories.")), true);
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"force_chunk").executes(c -> {
            class_1923 pos = new class_1923(class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222()));
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2791 source = level.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_12803, false);
            if (source instanceof class_2818) {
                class_2818 levelChunk = (class_2818)source;
                for (class_2586 be : levelChunk.method_12214().values()) {
                    ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Forcing BlockEntity[" + String.valueOf(be) + "] at " + String.valueOf(be.method_11016()) + " to be added to the queue.")), false);
                    BlockEntityTicker.addEntity(be, (class_1937)level, pos);
                }
            } else {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Chunk at " + pos.field_9181 + ", " + pos.field_9180 + " is not loaded somehow!")));
                return 0;
            }
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"force_radius").then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> {
            int radius;
            try {
                radius = IntegerArgumentType.getInteger((CommandContext)c, (String)"radius");
            }
            catch (NumberFormatException e) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Radius must be an integer."));
                return 0;
            }
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_1923 center = new class_1923(class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222()));
            for (int x = center.field_9181 - radius; x <= center.field_9181 + radius; ++x) {
                for (int z = center.field_9180 - radius; z <= center.field_9180 + radius; ++z) {
                    class_1923 pos = new class_1923(x, z);
                    class_2791 source = level.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_12803, false);
                    if (!(source instanceof class_2818)) continue;
                    class_2818 levelChunk = (class_2818)source;
                    for (class_2586 be : levelChunk.method_12214().values()) {
                        ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Forcing BlockEntity[" + String.valueOf(be) + "] at " + String.valueOf(be.method_11016()) + " to be added to the queue.")), false);
                        BlockEntityTicker.addEntity(be, (class_1937)level, pos);
                    }
                }
            }
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"force_all").executes(c -> {
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            for (class_3193 holder : ((IChunkMapGetChunks)level.method_14178().field_17254).lootr$getChunks()) {
                if (!holder.method_20384()) continue;
                holder.method_20385();
                class_2791 chunk = holder.method_60471();
                if (!(chunk instanceof class_2818)) continue;
                class_2818 levelChunk = (class_2818)chunk;
                class_1923 pos = levelChunk.method_12004();
                for (class_2586 be : levelChunk.method_12214().values()) {
                    ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Forcing BlockEntity[" + String.valueOf(be) + "] at " + String.valueOf(be.method_11016()) + " to be added to the queue.")), false);
                    BlockEntityTicker.addEntity(be, (class_1937)level, pos);
                }
            }
            return 1;
        }));
        return builder;
    }

    private static List<class_1923> getAllChunkPositions(class_3218 level) {
        class_32.class_5143 storage = ((AccessorMixinMinecraftServer)level.method_8503()).Lootr$getStorageSource();
        class_9240 regionstorageinfo = new class_9240(storage.method_27005(), level.method_27983(), "lootr");
        Path path = storage.method_27424(level.method_27983()).resolve("region");
        File[] directoryListing = path.toFile().listFiles(MCA_FILTER);
        if (directoryListing == null) {
            return List.of();
        }
        ArrayList<class_1923> allGeneratedChunkPositions = new ArrayList<class_1923>();
        for (File potentialRegionFile : directoryListing) {
            Matcher matcher = REGEX.matcher(potentialRegionFile.getName());
            if (!matcher.matches()) continue;
            int i = Integer.parseInt(matcher.group(1)) << 5;
            int j = Integer.parseInt(matcher.group(2)) << 5;
            ArrayList regionChunks = Lists.newArrayList();
            try (class_2861 regionfile = new class_2861(regionstorageinfo, potentialRegionFile.toPath(), path, true);){
                for (int k = 0; k < 32; ++k) {
                    for (int l = 0; l < 32; ++l) {
                        class_1923 chunkpos = new class_1923(k + i, l + j);
                        if (!regionfile.method_21879(chunkpos)) continue;
                        regionChunks.add(chunkpos);
                    }
                }
                if (regionChunks.isEmpty()) continue;
                allGeneratedChunkPositions.addAll(regionChunks);
            }
            catch (Throwable throwable) {
                LootrAPI.LOG.error("Failed to read chunks from region file {}", (Object)potentialRegionFile.toPath(), (Object)throwable);
            }
        }
        return allGeneratedChunkPositions;
    }

    static class_2680 updateBlockState(class_2680 oldState, class_2680 newState) {
        if (oldState.method_28498((class_2769)class_2741.field_12525) && newState.method_28498((class_2769)class_2741.field_12525)) {
            newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12525, (Comparable)((class_2350)oldState.method_11654((class_2769)class_2741.field_12525)));
        }
        if (oldState.method_28498((class_2769)class_2383.field_11177) && newState.method_28498((class_2769)class_2383.field_11177)) {
            newState = (class_2680)newState.method_11657((class_2769)class_2383.field_11177, (Comparable)((class_2350)oldState.method_11654((class_2769)class_2383.field_11177)));
        }
        if (oldState.method_28498((class_2769)class_2741.field_12508) && newState.method_28498((class_2769)class_2741.field_12508)) {
            newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)oldState.method_11654((class_2769)class_2741.field_12508)));
        }
        return newState;
    }
}

